define([
    'backbone',
    'models/resource-model',
    'json!externalLinksJson',
],
function (Backbone, Resource, externalLinksJson) {
    'use strict';

    // model
    var ExternalLink = Resource.extend({

        // eslint-disable-next-line consistent-return
        validate: function () {
            if (!this.get('id')) {
                return 'id is a required field';
            }
            if (!this.get('title')) {
                return 'title is a required field';
            }
            if (!this.get('href')) {
                return 'href is a required field';
            }
        },
        // formatHref() from Resource model
    });

    // collection
    return Backbone.Collection.extend({
        model: ExternalLink,
        parse: function(response) {
            return response.links;
        },
        initialize: function() {
            this.set(externalLinksJson, {parse: true});
        },
    });
});
